package it.eng.eremita.jpa.entity;

import java.io.Serializable;
import java.sql.Clob;
import java.util.Date;
import java.util.List;
import java.util.Optional;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.JoinTable;
import javax.persistence.Lob;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;

import io.leangen.graphql.annotations.GraphQLQuery;
import it.eng.eremita.graphql.annotations.Metadata;
import it.eng.eremita.graphql.types.Identifiable;
import it.eng.eremita.graphql.types.Trackable;
import it.eng.eremita.jpa.manager.Accessor;

@Entity
@Table(name="EREMITA_DOCUMENTO")
@SequenceGenerator(name="SEQ_DOCUMENTO", sequenceName="SEQ_DOCUMENTO", initialValue=1, allocationSize=1)
@Metadata(prefixes={"ALL","DOC"},nomeEntita="documento")
public class Documento implements Serializable,Identifiable<Long>,Trackable<Utente,Long> {
	
	Long id;
	String uuid;
	String nomeFile;
	String idInterno;
	String formato;
	String descrizione;
	
	String entita;
	Long idEntita;
	String inElenco;

	
	Utente utenteCreazione;
	Utente utenteModifica;
	Date dataCreazione;
	Date dataModifica;
	
	Optional<MonitoraggioSpecie> monitoraggioSpecie;
	

	@Id
	@GeneratedValue(strategy=GenerationType.SEQUENCE,generator="SEQ_DOCUMENTO")
	@Column(name="ID")
	@GraphQLQuery(name="id")
	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	@Column(name="UUID")
	@GraphQLQuery(name="uuid")
	public String getUuid() {
		return uuid;
	}

	public void setUuid(String uuid) {
		this.uuid = uuid;
	}

	@Column(name="NOME_FILE")
	@GraphQLQuery(name="nomeFile")
	public String getNomeFile() {
		return nomeFile;
	}

	public void setNomeFile(String nomeFile) {
		this.nomeFile = nomeFile;
	}

	@Column(name="ID_INTERNO")
	@GraphQLQuery(name="idInterno")
	public String getIdInterno() {
		return idInterno;
	}

	public void setIdInterno(String idInterno) {
		this.idInterno = idInterno;
	}

	@Column(name="FORMATO")
	@GraphQLQuery(name="formato")
	public String getFormato() {
		return formato;
	}

	public void setFormato(String formato) {
		this.formato = formato;
	}

	@Column(name="ENTITA")
	@GraphQLQuery(name="entita")
	public String getEntita() {
		return entita;
	}

	public void setEntita(String entita) {
		this.entita = entita;
	}

	@Column(name="ID_ENTITA")
	@GraphQLQuery(name="idEntita")
	public Long getIdEntita() {
		return idEntita;
	}

	public void setIdEntita(Long idEntita) {
		this.idEntita = idEntita;
	}

	@Column(name="DESCRIZIONE")
	@GraphQLQuery(name="descrizione")
	//@Lob
	public String getDescrizione() {
		return descrizione;
	}

	public void setDescrizione(String descrizione) {
		this.descrizione = descrizione;
	}

	
	
	@ManyToOne
	@JoinColumn(name="UTENTE_CREAZIONE")
	@GraphQLQuery(name="utenteCreazione")
	public Utente getUtenteCreazione() {
		return utenteCreazione;
	}

	public void setUtenteCreazione(Utente utenteCreazione) {
		this.utenteCreazione = utenteCreazione;
	}

	@ManyToOne
	@JoinColumn(name="UTENTE_MODIFICA")
	@GraphQLQuery(name="utenteModifica")
	public Utente getUtenteModifica() {
		return utenteModifica;
	}

	public void setUtenteModifica(Utente utenteModifica) {
		this.utenteModifica = utenteModifica;
	}

	@Temporal(TemporalType.TIMESTAMP)
	@Column(name="DATA_CREAZIONE")
	@GraphQLQuery(name="dataCreazione")
	public Date getDataCreazione() {
		return dataCreazione;
	}

	public void setDataCreazione(Date dataCreazione) {
		this.dataCreazione = dataCreazione;
	}

	@Temporal(TemporalType.TIMESTAMP)
	@Column(name="DATA_MODIFICA")
	@GraphQLQuery(name="dataModifica")
	public Date getDataModifica() {
		return dataModifica;
	}

	public void setDataModifica(Date dataModifica) {
		this.dataModifica = dataModifica;
	}
	
	@Column(name="IN_ELENCO")
	@GraphQLQuery(name="inElenco")
	public String getInElenco() {
		return inElenco;
	}

	public void setInElenco(String inElenco) {
		this.inElenco = inElenco;
	}
	


	/*@Transient
	@GraphQLQuery(name="monitoraggioSpecie")
	public MonitoraggioSpecie getMonitoraggioSpecie() {
		if (monitoraggioSpecie==null && getId()!=null) {
			List<MonitoraggioSpecie> ms = (List<MonitoraggioSpecie>)Accessor.getEremitaManager().getSql(
					MonitoraggioSpecie.class, "select ms.* from eremita_monitoraggio_specie ms join eremita_monit_specie_doc d on ms.id = d.monitoraggio_specie where documento="+id);
			MonitoraggioSpecie mm = (ms!=null&&ms.size()>0?ms.get(0):null);
			monitoraggioSpecie = Optional.ofNullable(mm);
			}
		return monitoraggioSpecie.orElse(null);
	}

	public void setMonitoraggioSpecie(MonitoraggioSpecie monitoraggioSpecie) {
		this.monitoraggioSpecie = Optional.ofNullable(monitoraggioSpecie);
	}*/

	public boolean equals(Object o) {
		if (o==null) return false;
		
		if (!(o instanceof Documento)) return false;
		
		Documento ms = (Documento)o;
		return (ms.getId()==this.getId());

	}
	
	@Override
	public String toString() {
		return "Documento-"+getId();
	}
	
	@Override
	public int hashCode() {
		return (int)( getId()%Integer.MAX_VALUE);
	}
	
	

}
